uniform sampler2D s_texture0; // the texture with the scene you want to blur
varying vec2 v_texCoord;

const float blurSize = 1.0/64.0;

void main(void)
{
  vec4 sum = vec4(0.0);
  
  // blur in x (horizontal)
  sum += texture2D(s_texture0, vec2(v_texCoord.x - 7.0*blurSize, v_texCoord.y)) * 0.02;
  sum += texture2D(s_texture0, vec2(v_texCoord.x - 6.0*blurSize, v_texCoord.y)) * 0.032;
  sum += texture2D(s_texture0, vec2(v_texCoord.x - 5.0*blurSize, v_texCoord.y)) * 0.046;
  sum += texture2D(s_texture0, vec2(v_texCoord.x - 4.0*blurSize, v_texCoord.y)) * 0.06;
  sum += texture2D(s_texture0, vec2(v_texCoord.x - 3.0*blurSize, v_texCoord.y)) * 0.075;
  sum += texture2D(s_texture0, vec2(v_texCoord.x - 2.0*blurSize, v_texCoord.y)) * 0.088;
  sum += texture2D(s_texture0, vec2(v_texCoord.x - blurSize, v_texCoord.y)) * 0.097;
  sum += texture2D(s_texture0, vec2(v_texCoord.x, v_texCoord.y)) * 0.1;
  sum += texture2D(s_texture0, vec2(v_texCoord.x + blurSize, v_texCoord.y)) * 0.097;
  sum += texture2D(s_texture0, vec2(v_texCoord.x + 2.0*blurSize, v_texCoord.y)) * 0.088;
  sum += texture2D(s_texture0, vec2(v_texCoord.x + 3.0*blurSize, v_texCoord.y)) * 0.075;
  sum += texture2D(s_texture0, vec2(v_texCoord.x + 4.0*blurSize, v_texCoord.y)) * 0.06;
  sum += texture2D(s_texture0, vec2(v_texCoord.x + 5.0*blurSize, v_texCoord.y)) * 0.046;
  sum += texture2D(s_texture0, vec2(v_texCoord.x + 6.0*blurSize, v_texCoord.y)) * 0.032;
  sum += texture2D(s_texture0, vec2(v_texCoord.x + 7.0*blurSize, v_texCoord.y)) * 0.02;

  gl_FragColor = sum;
}